/**
* \file: LibraryEntryPoint.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay - Wayland Adapter
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <dipo_plugin.h>
#include <adit_logging.h>
#include "WaylandTouchInput.h"

LOG_DECLARE_CONTEXT(dipo_wl);

using namespace adit::carplay;

extern "C" DIPO_WL_EXPORTED_SYMBOL void carplay_LibraryEntryPoint()
{
    // register wl-touch at logging
    LOG_REGISTER_CONTEXT(dipo_wl, "CWLT", "CarPlay Wayland touch");

    LOGD_DEBUG((dipo_wl, "carplay-wl-touch git tag: %s", COMP_GIT_VERSION));
    carplay_FactoryRegister<IInputAdapter, WaylandTouchInput>("WaylandTouchInput");
}

extern "C" DIPO_WL_EXPORTED_SYMBOL void carplay_LibraryExitPoint()
{
    LOG_UNREGISTER_CONTEXT(dipo_wl);
}
